<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('id', 'name_ar', 'name_en', 'timestamps');

    public function agencies()
    {
        return $this->hasMany('App\Models\Agency');
    }

    public function cities()
    {
        return $this->hasMany('App\Models\City');
    }

    public function rental_offices()
    {
        return $this->hasMany('App\Models\RentalOffice');
    }

    public function show_rooms()
    {
        return $this->hasMany('App\Models\CarsShowRoom');
    }

    public function selling_special_numbers()
    {
        return $this->hasMany('App\Models\SellingSpecialNumber');
    }

    public function garages()
    {
        return $this->hasMany('App\Models\Garage');
    }

    public function winches()
    {
        return $this->hasMany('App\Models\Winch');
    }

}